/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.core.util.ArrayUtil;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.BuildPathsNode;
import com.aptana.scripting.ui.views.BundleNode;
import com.aptana.scripting.ui.views.CommandsNode;
import com.aptana.scripting.ui.views.EnvsNode;
import com.aptana.scripting.ui.views.FileTemplatesNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.MenusNode;
import com.aptana.scripting.ui.views.Messages;
import com.aptana.scripting.ui.views.ProjectSamplesNode;
import com.aptana.scripting.ui.views.ProjectTemplatesNode;
import com.aptana.scripting.ui.views.SnippetCategoriesNode;
import com.aptana.scripting.ui.views.SnippetsNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleEntryNode
extends BaseNode<Property> {
    private static final Image BUNDLE_ENTRY_ICON = ScriptingUIPlugin.getImage("icons/bundle_entry.png");
    private BundleEntry entry;
    private Action reloadAction;

    BundleEntryNode(BundleEntry entry) {
        this.entry = entry;
        this.makeActions();
    }

    private void addNode(List<Object> items, BaseNode<?> node) {
        if (node != null && node.hasChildren()) {
            items.add(node);
        }
    }

    @Override
    public Action[] getActions() {
        return new Action[]{this.reloadAction};
    }

    @Override
    public Object[] getChildren() {
        if (this.entry == null) {
            return ArrayUtil.NO_STRINGS;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (BundleElement bundle : this.entry.getBundles()) {
            result.add(new BundleNode(bundle));
        }
        this.addNode(result, new CommandsNode(this.entry.getCommands()));
        this.addNode(result, new SnippetsNode(this.entry.getCommands()));
        this.addNode(result, new SnippetCategoriesNode(this.entry.getSnippetCategories()));
        this.addNode(result, new FileTemplatesNode(this.entry.getCommands()));
        this.addNode(result, new MenusNode(this.entry.getMenus()));
        this.addNode(result, new BuildPathsNode(this.entry.getBuildPaths()));
        this.addNode(result, new EnvsNode(this.entry.getEnvs()));
        this.addNode(result, new ProjectTemplatesNode(this.entry.getProjectTemplates()));
        this.addNode(result, new ProjectSamplesNode(this.entry.getProjectSamples()));
        return result.toArray();
    }

    @Override
    public Image getImage() {
        return BUNDLE_ENTRY_ICON;
    }

    @Override
    public String getLabel() {
        return this.entry == null ? "" : this.entry.getName();
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public boolean hasChildren() {
        if (this.entry == null) {
            return false;
        }
        for (BundleElement bundle : this.entry.getBundles()) {
            if (!bundle.hasChildren()) continue;
            return true;
        }
        return false;
    }

    private void makeActions() {
        this.reloadAction = new Action(){

            public void run() {
                BundleEntryNode.this.entry.reload();
            }
        };
        this.reloadAction.setText(Messages.BundleEntryNode_TXT_Reload);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<BundleEntryNode>
    {
        NAME(Messages.BundleEntryNode_Bundle_Entry_Name){

            public Object getPropertyValue(BundleEntryNode node) {
                return node.entry == null ? null : node.entry.getName();
            }
        }
        ,
        CONTRIBUTOR_COUNT(Messages.BundleEntryNode_Bundle_Entry_Contributor_Count){

            public Object getPropertyValue(BundleEntryNode node) {
                return node.entry == null ? null : Integer.valueOf(node.entry.getBundles().size());
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

